///////////////////////////////////////////////////////////
// Tracker scheme resource file
//
// sections:
//		Colors			- all the colors used by the scheme
//		BaseSettings		- contains settings for app to use to draw controls
//		Fonts			- list of all the fonts used by app
//		White			- description of all the White
//
///////////////////////////////////////////////////////////
Scheme
{
	//////////////////////// COLORS ///////////////////////////
	// color details
	// this is a list of all the colors used by the scheme
	Colors
	{
		// base colors
		"Nira1"						"0 100 175 255"
		"Nira2"						"0 100 175 128"
		"White"						"255 255 255 255"
		"TransparentWhite"				"255 255 255 128"
		"Black"						"0 0 0 255"
		"TransparentBlack"			"0 0 0 50"		//"0 0 0 128"
		"Blank"						"0 0 0 0"
	}

	///////////////////// BASE SETTINGS ////////////////////////
	//
	// default settings for all panels
	// controls use these to determine their settings
	BaseSettings
	{
		// vgui_controls color specifications
		Border.Bright					"Black"
		Border.Dark					"Black"
		Border.Selection				"White" 

		Button.TextColor				"White"
		Button.BgColor					"TransparentBlack"
		Button.ArmedTextColor				"White"
		Button.ArmedBgColor				"TransparentBlack"		[$WIN32]
		Button.ArmedBgColor				"TransparentBlack"		[$X360]
		Button.DepressedTextColor			"White"
		Button.DepressedBgColor				"Nira2"
		Button.FocusBorderColor				"Black"
		
		CheckButton.TextColor				"White"
		CheckButton.SelectedTextColor			"White"
		CheckButton.BgColor				"TransparentBlack"
		CheckButton.Border1  				"Nira1"
		CheckButton.Border2  				"Nira1"
		CheckButton.Check				"White"

		ComboBoxButton.ArrowColor			"White"
		ComboBoxButton.ArmedArrowColor			"White"
		ComboBoxButton.BgColor				"Blank"
		ComboBoxButton.DisabledBgColor			"Blank"

		"Chat.TypingText"				"White"

		Frame.TitleTextInsetX				16
		Frame.ClientInsetX				8
		Frame.ClientInsetY				6
		Frame.BgColor					"TransparentBlack"	[$WIN32]
		Frame.BgColor					"TransparentBlack"	[$X360]
		Frame.OutOfFocusBgColor				"TransparentBlack"	[$WIN32]
		Frame.OutOfFocusBgColor				"TransparentBlack"	[$X360]
		Frame.FocusTransitionEffectTime			"0.05"
		Frame.TransitionEffectTime			"0.05"
		Frame.AutoSnapRange				"0"
		FrameGrip.Color1				"White"
		FrameGrip.Color2				"TransparentBlack"
		FrameTitleButton.FgColor			"White" 
		FrameTitleButton.BgColor			"Blank"
		FrameTitleButton.DisabledFgColor		"TransparentBlack"
		FrameTitleButton.DisabledBgColor		"Blank"
		FrameSystemButton.FgColor			"Blank"
		FrameSystemButton.BgColor			"Blank"
		FrameSystemButton.Icon				""
		FrameSystemButton.DisabledIcon			""
		FrameTitleBar.Font				"UiBold"		[$WIN32]
		FrameTitleBar.Font				"DefaultLarge"		[$WIN32]
		FrameTitleBar.TextColor				"White"
		FrameTitleBar.BgColor				"Blank"
		FrameTitleBar.DisabledTextColor			"White"
		FrameTitleBar.DisabledBgColor			"Blank"

		GraphPanel.FgColor				"White"
		GraphPanel.BgColor				"TransparentBlack"

		Label.TextDullColor				"TransparentBlack"	
		Label.TextColor					"White"  	
		Label.TextBrightColor				"White" 		
		Label.SelectedTextColor				"White"
		Label.BgColor					"Blank"
		Label.DisabledFgColor1				"TransparentWhite"	
		Label.DisabledFgColor2				"Blank"

		ListPanel.TextColor				"White" 
		ListPanel.TextBgColor				"Blank"
		ListPanel.BgColor				"TransparentBlack"
		ListPanel.SelectedTextColor			"Black"
		ListPanel.SelectedBgColor			"White"
		ListPanel.SelectedOutOfFocusBgColor		"TransparentWhite"
		ListPanel.EmptyListInfoTextColor		"Blank"

		Menu.TextColor					"White"
		Menu.BgColor					"Nira1"
		Menu.ArmedTextColor				"White"
		Menu.ArmedBgColor				"Nira1" 
		Menu.TextInset					"6"

		Panel.FgColor					"Blank"
		Panel.BgColor					"Blank"

		ProgressBar.FgColor				"Nira1"
		ProgressBar.BgColor				"TransparentBlack"

		PropertySheet.TextColor				"TransparentWhite"
		PropertySheet.SelectedTextColor			"White"
		PropertySheet.TransitionEffectTime		"0.25"


		RadioButton.TextColor				"TransparentWhite" // skal måske ændres
		RadioButton.SelectedTextColor			"White"

		RichText.TextColor				"TransparentWhite"
		RichText.BgColor				"TransparentBlack"
		RichText.SelectedTextColor			"White"
		RichText.SelectedBgColor			"Nira2"

		ScrollBar.Wide					"11"

		
		ScrollBarButton.FgColor				"TransparentWhite"
		ScrollBarButton.BgColor				"Blank"
		ScrollBarButton.ArmedFgColor			"White"
		ScrollBarButton.ArmedBgColor			"Blank"
		ScrollBarButton.DepressedFgColor		"White"
		ScrollBarButton.DepressedBgColor		"TransparentBlack"

		ScrollBarSlider.FgColor				"Blank"
		ScrollBarSlider.BgColor				"TransparentBlack"

		SectionedListPanel.HeaderTextColor		"White"
		SectionedListPanel.HeaderBgColor		"Blank"
		SectionedListPanel.DividerColor			"Nira1"
		SectionedListPanel.TextColor			"White"
		SectionedListPanel.BrightTextColor		"White"
		SectionedListPanel.BgColor			"TransparentBlack"
		SectionedListPanel.SelectedTextColor		"White"
		SectionedListPanel.SelectedBgColor		"Nira2"
		SectionedListPanel.OutOfFocusSelectedTextColor	"Nira2"
		SectionedListPanel.OutOfFocusSelectedBgColor	"Nira2"


		TextEntry.TextColor				"White"
		TextEntry.BgColor				"TransparentBlack"
		TextEntry.CursorColor				"Nira2"
		TextEntry.DisabledTextColor			"TransparentWhite"
		TextEntry.DisabledBgColor			"Blank"
		TextEntry.SelectedTextColor			"White"
		TextEntry.SelectedBgColor			"Nira2"
		TextEntry.OutOfFocusSelectedBgColor		"Nira2"
		TextEntry.FocusEdgeColor			"Blank"

		ToggleButton.SelectedTextColor			"White"

		Tooltip.TextColor				"TransparentWhite"
		Tooltip.BgColor					"TransparentBlack"

		TreeView.BgColor				"TransparentBlack"

		WizardSubPanel.BgColor				"Blank"

		// scheme-specific colors
		MainMenu.TextColor				"White"			[$WIN32]
		MainMenu.TextColor				"White"			[$X360]
		MainMenu.ArmedTextColor				"White"			[$WIN32]
		MainMenu.ArmedTextColor				"White"			[$X360]
		MainMenu.DepressedTextColor			"Blank"
		MainMenu.MenuItemHeight				"25"			[$WIN32]
		MainMenu.MenuItemHeight				"32"			[$X360]
		MainMenu.Inset					"32"
		MainMenu.Backdrop				"TransparentBlack"

		Console.TextColor				"White"
		Console.DevTextColor				"White"

		NewGame.TextColor				"White"
		NewGame.FillColor				"Black"
		NewGame.SelectionColor				"White"			[$WIN32]
		NewGame.SelectionColor				"Black"			[$X360]
		NewGame.DisabledColor				"Blank"			"128 128 128 196"
	}

	//////////////////////// BITMAP FONT FILES /////////////////////////////
	//
	// Bitmap Fonts are ****VERY*** expensive static memory resources so they are purposely sparse
	BitmapFontFiles
	{
		// UI buttons, custom font, (256x64)
		//"Buttons"		"materials/vgui/fonts/buttons_32.vbf"
	}

//////////////////////// FONTS /////////////////////////////
	//
	// describes all the fonts
	Fonts
	{

		"Default"
		{
			"1"
			{
				"name"		"Verdana"
				"tall"		"12"
				"weight"	"0"
				"range"		"0x0000 0x017F"
				"yres"	"480 599"
			}
			"2"
			{
				"name"		"Verdana"
				"tall"		"13"
				"weight"	"0"
				"range"		"0x0000 0x017F"
				"yres"	"600 767"
			}
			"3"
			{
				"name"		"Verdana"
				"tall"		"14"
				"weight"	"0"
				"range"		"0x0000 0x017F"
				"yres"	"768 1023"
				"antialias"	"1"
			}
			"4"
			{
				"name"		"Verdana"
				"tall"		"16"
				"weight"	"0"
				"range"		"0x0000 0x017F"
				"yres"	"1024 1199"
				"antialias"	"1"
			}
			"5"
			{
				"name"		"Verdana"
				"tall"		"20"
				"weight"	"0"
				"range"		"0x0000 0x017F"
				"yres"	"1200 6000"
				"antialias"	"1"
			}
		}
		
		// this is the symbol font
		"Marlett"
		{

			"1"
			{
				"name"		"Marlett"
				"tall"		"10"
				"weight"	"0"
				"yres"		"480 599"
				"symbol"	"1"
			}
			"2"
			{
				"name"		"Marlett"
				"tall"		"14"
				"weight"	"0"
				"yres"		"600 767"
				"symbol"	"1"
			}
			"3"
			{
				"name"		"Marlett"
				"tall"		"13"
				"weight"	"0"
				"yres"		"768 1023"
				"symbol"	"1"
			}
			"4"
			{
				"name"		"Marlett"
				"tall"		"17"
				"weight"	"0"
				"yres"		"1024 1199"
				"symbol"	"1"
			}
			"5"
			{
				"name"		"Marlett"
				"tall"		"22"
				"weight"	"0"
				"yres"		"1200 10000"
				"symbol"	"1"
			}
		}

		"ChatFont"
		{
			"1"
			{
				"name"		"Verdana"
				"tall"		"8" 		//"12"
				"weight"	"700"
				"yres"		"480 599"
				"outline" 	"1"
			}
			"2"
			{
				"name"		"Verdana"
				"tall"		"10" 		//"14"
				"weight"	"700"
				"yres"		"600 767"
				"outline" 	"1"
			}
			"3"
			{
				"name"		"Verdana"
				"tall"		"11" 		//"15"
				"weight"	"700"
				"yres"		"768 1023"
				"outline" 	"1"
			}
			"4"
			{
				"name"		"Verdana"
				"tall"		"13" 		//"17"
				"weight"	"700"
				"yres"		"1024 1199"
				"outline" 	"1"
			}
			"5"
			{
				"name"		"Verdana"
				"tall"		"18" 		//"22"
				"weight"	"700"
				"yres"		"1200 10000"
				"outline" 	"1"
			}
		}


	}

	//
	//////////////////// BORDERS //////////////////////////////
	//
	// describes all the border types
	Borders
	{
		BaseBorder		DepressedBorder
		ButtonBorder		RaisedBorder
		ComboBoxBorder		DepressedBorder
		MenuBorder		RaisedBorder
		BrowserBorder		DepressedBorder
		PropertySheetBorder	RaisedBorder

		FrameBorder
		{
			// rounded corners for frames
			"backgroundtype" "0"
			"inset" "0 0 1 1"
			Left
			{
				"1"
				{
					"color" "0 0 0 80" //Border.Dark
					"offset" "0 0"
				}
				"2"
				{
					"color" "255 255 255 255" //Border.Dark
					"offset" "1 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "0 0 0 80" //Border.Dark
					"offset" "0 0"
				}
				"2"
				{
					"color" "255 255 255 255" //Border.Dark
					"offset" "1 1"
				}
			}

			Top
			{
				"1"
				{
					"color" "0 0 0 80" //Border.Dark
					"offset" "0 0"
				}
				"2"
				{
					"color" "255 255 255 255" //Border.Dark
					"offset" "2 2"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "0 0 0 80" //Border.Dark
					"offset" "0 0"
				}
				"2"
				{
					"color" "255 255 255 255" //Border.Dark
					"offset" "2 2"
				}
			}
		}

		DepressedBorder
		{
			"inset" "0 0 1 1"
			Left
			{
				"1"
				{
					"color" "255 255 255 255" // Border.Dark
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "255 255 255 255" // Border.Bright
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "255 255 255 255"  // Border.Dark
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "255 255 255 255" // Border.Bright
					"offset" "0 0"
				}
			}
		}
		RaisedBorder
		{
			"inset" "0 0 1 1"
			Left
			{
				"1"
				{
					"color" "255 255 255 255" // Border.Bright
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "255 255 255 255"  // Border.Dark
					"offset" "0 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "255 255 255 255" // Border.Bright
					"offset" "0 1"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "255 255 255 255"  // Border.Dark
					"offset" "0 0"
				}
			}
		}
		
		TitleButtonBorder
		{
			"backgroundtype" "0"
		}

		TitleButtonDisabledBorder
		{
			"backgroundtype" "0"
		}

		TitleButtonDepressedBorder
		{
			"backgroundtype" "0"
		}

		ScrollBarButtonBorder
		{
			"inset" "2 2 0 0"
			Left
			{
				"1"
				{
					"color" "Nira1"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "Nira1"
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "Nira1"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "Nira1"
					"offset" "0 0"
				}
			}
		}

		ScrollBarSliderBorder
		{
			"inset" "2 2 0 0"
			Left
			{
				"1"
				{
					"color" "Nira1"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "Nira1"
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "Nira1"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "Nira1"
					"offset" "0 0"
				}
			}
		}


		ScrollBarButtonDepressedBorder
		{
			"inset" "2 2 0 0"
			Left
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "0 0"
				}
			}
		}

		TabBorder
		{
			"inset" "0 0 1 1"
			Left
			{
				"1"
				{
					"color" "255 255 255 255" // Border.Bright
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "255 255 255 255" // Border.Dark
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "255 255 255 255" // Border.Bright
					"offset" "0 0"
				}
			}

		}

		TabActiveBorder
		{
			"inset" "0 0 1 0"
			Left
			{
				"1"
				{
					"color" "255 255 255 255" // Border.Bright
					"offset" "0 0"
				}
			}

			Right
			{
				"1"
				{
					"color" "255 255 255 255" // Border.Dark
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "255 255 255 255t" // Border.Bright
					"offset" "0 0"
				}
			}

		}


		ToolTipBorder
		{
			"inset" "0 0 1 0"
			Left
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "0 0"
				}
			}

			Right
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "0 0"
				}
			}
		}

		// this is the border used for default buttons (the button that gets pressed when you hit enter)
		ButtonKeyFocusBorder
		{
			"inset" "0 0 1 1"
			Left
			{
				"1"
				{
					"color" "Border.Selection"
					"offset" "0 0"
				}
				"2"
				{
					"color" "Border.Bright"
					"offset" "0 1"
				}
			}
			Top
			{
				"1"
				{
					"color" "Border.Selection"
					"offset" "0 0"
				}
				"2"
				{
					"color" "Border.Bright"
					"offset" "1 0"
				}
			}
			Right
			{
				"1"
				{
					"color" "Border.Selection"
					"offset" "0 0"
				}
				"2"
				{
					"color" "Border.Dark"
					"offset" "1 0"
				}
			}
			Bottom
			{
				"1"
				{
					"color" "Border.Selection"
					"offset" "0 0"
				}
				"2"
				{
					"color" "Border.Dark"
					"offset" "0 0"
				}
			}
		}

		ButtonDepressedBorder
		{
			"inset" "2 1 1 1"
			Left
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "0 0"
				}
			}
		}
	}

	//////////////////////// CUSTOM FONT FILES /////////////////////////////
	//
	// specifies all the custom (non-system) font files that need to be loaded to service the above described fonts
	CustomFontFiles
	{
		"1"		"resource/HALFLIFE2.ttf"
		"2"		"resource/HL2EP2.ttf"		
	}
}